unit CapEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CapCtrl, StdCtrls, ExtCtrls;

type
  TCaptionButtonsEditor = class(TForm)
    ItemsGroup: TGroupBox;
    ItemPropGroup: TGroupBox;
    ItemsListBox: TListBox;
    NewBtn: TButton;
    DeleteBtn: TButton;
    CaptionLbl: TLabel;
    CaptionEdit: TEdit;
    EnabledBox: TCheckBox;
    VisibleBox: TCheckBox;
    PushedBox: TCheckBox;
    OKBtn: TButton;
    CancelBtn: TButton;
    ApplyBtn: TButton;
    KindLbl: TLabel;
    KindCombo: TComboBox;
    MyCaption: TCaptionControl;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CaptionEditChange(Sender: TObject);
    procedure ItemsListBoxClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure NewBtnClick(Sender: TObject);
    procedure MyCaptionButtonClick(Sender: TObject; ButtonIndex: Integer;
      var Pushed: Boolean);
  private
    { Private declarations }
    BtnList: TCaptionButtonsList;
    CapCtrl: TCaptionControl;
  public
    { Public declarations }
    procedure ReadBtnList(InBtn: TCaptionButtonsList);
    procedure UpdateBtnList(OutBtn: TCaptionButtonsList);
    procedure FillListBox;
    procedure SelectFirstItem;
  end;

function EditCaptionButtons(Buttons: TCaptionButtonsList; CaptionControl: TCaptionControl): Boolean;

implementation

{$R *.DFM}

uses
  CapAbout;

function EditCaptionButtons(Buttons: TCaptionButtonsList; CaptionControl: TCaptionControl): Boolean;
var
  EditorForm: TCaptionButtonsEditor;
begin
  Result := False;
  Application.CreateForm(TCaptionButtonsEditor, EditorForm);
  with EditorForm do
  try
    CapCtrl := CaptionControl;
    ReadBtnList(Buttons);
    SelectFirstItem;
    if ShowModal=mrOk then
    begin
      UpdateBtnList(Buttons);
      Result := True;
    end;
  finally
    Free;
  end;
end;

procedure TCaptionButtonsEditor.FormCreate(Sender: TObject);
begin
  BtnList := TCaptionButtonsList.Create(Self);
end;

procedure TCaptionButtonsEditor.FormDestroy(Sender: TObject);
begin
  BtnList.Free;
end;

procedure TCaptionButtonsEditor.ReadBtnList(InBtn: TCaptionButtonsList);
var
  i: Integer;
begin
  BtnList.Clear;
  if InBtn.Count>0 then
    for i:=0 to InBtn.Count-1 do
      with InBtn[i] do
        BtnList.AddButton(Caption, Enabled, Visible, Pushed, Kind);
  FillListBox;
end;

procedure TCaptionButtonsEditor.UpdateBtnList(OutBtn: TCaptionButtonsList);
var
  i: Integer;
begin
  while OutBtn.Count<BtnList.Count do
    OutBtn.AddButton('x', True, True, False, cbkCustom);
  while OutBtn.Count>BtnList.Count do
    OutBtn.Delete(OutBtn.Count-1);
  if BtnList.Count>0 then
    for i:=0 to OutBtn.Count-1 do
    begin
      with OutBtn[i] do
      begin
        Enabled := BtnList[i].Enabled;
        Visible := BtnList[i].Visible;
        Pushed := BtnList[i].Pushed;
        Caption := BtnList[i].Caption;
        Kind := BtnList[i].Kind;
      end;
    end;
end;

procedure TCaptionButtonsEditor.CaptionEditChange(Sender: TObject);
var
  b: Boolean;
begin
  b := CaptionEdit.Text <> '';
  EnabledBox.Enabled := b;
  VisibleBox.Enabled := b;
  PushedBox.Enabled := b;
  ApplyBtn.Enabled := b;
end;

procedure TCaptionButtonsEditor.ItemsListBoxClick(Sender: TObject);
var
  b: Boolean;
  i: Integer;
begin
  i:= ItemsListBox.ItemIndex;
  b := ((i>=0) and (ItemsListBox.Items.Count>0));
  DeleteBtn.Enabled := b;
  CaptionEdit.Enabled := b;
  EnabledBox.Enabled := b;
  VisibleBox.Enabled := b;
  PushedBox.Enabled := b;
  ApplyBtn.Enabled := b;
  if b then
  begin
    CaptionEdit.Text := BtnList[i].Caption;
    EnabledBox.Checked := BtnList[i].Enabled;
    VisibleBox.Checked := BtnList[i].Visible;
    PushedBox.Checked := BtnList[i].Pushed;
    KindCombo.ItemIndex := KindCombo.Items.IndexOf(BtnList[i].GetBtnKindStr);
  end else
  begin
    CaptionEdit.Text := '';
    EnabledBox.Checked := False;
    VisibleBox.Checked := False;
    PushedBox.Checked := False;
    KindCombo.ItemIndex := KindCombo.Items.IndexOf('cbkCustom');
  end;
end;

procedure TCaptionButtonsEditor.DeleteBtnClick(Sender: TObject);
var
  i: Integer;
begin
  i := ItemsListBox.ItemIndex;
  if i<0 then exit;
  BtnList.Delete(i);
  ItemsListBox.Items.Delete(i);
  while i>=ItemsListBox.Items.Count do Dec(i);
  if i>=0 then
  begin
    ItemsListBox.ItemIndex := i;
    ItemsListBox.SetFocus;
    ItemsListBoxClick(Self);
  end;
  ActiveControl := ItemsListBox;
end;

procedure TCaptionButtonsEditor.FillListBox;
var
  i: Integer;
begin
  while ItemsListBox.Items.Count>BtnList.Count do
    ItemsListBox.Items.Delete(ItemsListBox.Items.Count-1);
  while ItemsListBox.Items.Count<BtnList.Count do
    ItemsListBox.Items.Add('');
  if BtnList.Count>0 then
    for i:=0 to BtnList.Count-1 do
      ItemsListBox.Items[i] := BtnList[i].Caption;
  SelectFirstItem;
end;

procedure TCaptionButtonsEditor.ApplyBtnClick(Sender: TObject);
var
  i: Integer;
begin
  i:=ItemsListBox.ItemIndex;
  if i<0 then exit;
  with BtnList[i] do
  begin
    Caption := CaptionEdit.Text;
    Enabled := EnabledBox.Checked;
    Visible := VisibleBox.Checked;
    Pushed := PushedBox.Checked;
    SetBtnKindStr(KindCombo.Items[KindCombo.ItemIndex]);
    ItemsListBox.Items[i] := Caption;
    ItemsListBox.SetFocus;
    ItemsListBox.ItemIndex := i;
    ItemsListBoxClick(Self);
  end;
  ActiveControl := ItemsListBox;
end;

procedure TCaptionButtonsEditor.NewBtnClick(Sender: TObject);
begin
  BtnList.Add(TCaptionButton.Create);
  with BtnList[BtnList.Count-1] do
  begin
    Caption := 'Untitled';
    ItemsListBox.Items.Add(Caption);
    ItemsListBox.ItemIndex := ItemsListBox.Items.Count-1;
    ItemsListBoxClick(Self);
  end;
  ActiveControl := ItemsListBox;
end;

procedure TCaptionButtonsEditor.SelectFirstItem;
begin
  if BtnList.Count=0 then exit;
  ItemsListBox.ItemIndex := 0;
  ItemsListBoxClick(Self);
  ActiveControl := ItemsListBox;
end;

procedure TCaptionButtonsEditor.MyCaptionButtonClick(Sender: TObject;
  ButtonIndex: Integer; var Pushed: Boolean);
var
  AboutBox: TCaptionControlAbout;
begin
  Application.CreateForm(TCaptionControlAbout, AboutBox);
  try
    AboutBox.ShowModal;
  finally
    AboutBox.Free;
  end;
end;

end.
